# Clark McAllister
#30/09/2024
"""
This program will take in a list of words and randomly select a specific amount
as requested by the user.

Features:
-Input words
    -Individually
    -List (all at once)
-Return random words
    -Combine words
    -Individual words
    -Specific number of words
-Save
    -Initial list
    -Generated words
"""

import random
import datetime

#Variables
initialWords = [] # Stores the words the user entered
generatedWords = [] # Stores the words that were generated

def EnterSelect():
    global initialWords
    
    print("Would you like to:")
    print("1. Enter a list of words")
    print("2. Enter words invidually")
    enterOption = int(input("Enter the number to select: "))

    if enterOption == 1:
        initialWords = EnterList()
    elif enterOption == 2:
        EnterIndividually()
    else:
        print("Invalid option: Please select number 1 or 2.\n")
        EnterSelect()

def EnterList():
    global initialWords
    
    # Clear initialWords
    if len(initialWords) > 0:
        initialWords.clear()

    print("Add your list into the \"list.txt\" file in the directory where this program is.")
    print("Please make sure each word is on a seperate line.")
    try:
        file = open("list.txt", "x")
    except:
        pass
    input("Press enter to confirm you have done this.")
    file = open("list.txt", "r")
    initialWords = file.read().split("\n")
    file.close()

    # Generate Words
    GenerateWords(GenerateNumber())

def EnterIndividually():
    userWord = ""
    global initialWords
    
    # Clear initialWords
    if len(initialWords) > 0:
        initialWords.clear()

    print("Enter your words here (Type \"/END/\" to stop entering words):")

    while userWord.upper() != "/END/":
        userWord = input()
        if userWord.upper() != "/END/":
            initialWords.append(userWord)

    # Generate Words
    GenerateWords(GenerateNumber())

def GenerateNumber():
    print("-------------------")
    return int(input("How many words would you like to generate: "))

def GenerateWords(loop):
    global generatedWords
    global initialWords
    
    # Clear generatedWords
    if len(generatedWords) > 0:
        generatedWords.clear()

    # Loop got how many words the user wants
    for index in range(loop):
        rand = random.randint(0, (len(initialWords) - 1))
        generatedWords.append(initialWords[rand])
        initialWords.remove(initialWords[rand])

    DisplayWords()

def DisplayWords():
    saveOption = 0 # Stores if the user wants to save, regenerate, enter new words, or exit
    
    print("-------------------")
    print("The words that have been generated are:")
    for index in range(len(generatedWords)):
        print(str(index + 1) + ". " + generatedWords[index])

    saveOption = SaveSelect()
    if saveOption == 1:
        # Save File
        SaveFile()
    elif saveOption == 2:
        EnterSelect()
    elif saveOption == 3:
        pass

def SaveSelect():
    print("-------------------")
    print("Would you like to:")
    print("1. Save the list to your computer")
    print("2. Enter new words (this will override your previous words)")
    print("3. Exit the program")
    return int(input("Enter the number to select: "))

def SaveFile():
    # Open/create file
    currentTime = datetime.datetime.now()
    fileName = "Generated List " + str(currentTime.year) + "-" + str(currentTime.month) + "-" + str(currentTime.day) + " " + str(currentTime.hour) + "-" + str(currentTime.minute) + "-" + str(currentTime.second) + ".txt"
    
    file = open("Generated Lists/" + fileName, "a")

    # Check if the user wants the numbers or not
    numbers = input("Do you wish to have the item numbers next to your words saved (Y/N)?: ")
    for index in range(len(generatedWords)):
        if numbers.upper() == "Y" or numbers.upper() == "YES":
            file.write(str(index + 1) + ". " +generatedWords[index] + "\n")
        else:
            file.write(generatedWords[index] + "\n")
    file.close()

    print("Your list can be found in the folder \"Generated Lists\" (in the folder where this program is) under the name " + fileName)

def main():
    print("------Welcome------")

    EnterSelect()
    

if __name__ == "__main__":
    main()
